# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .code import Code
from .codeable_concept import CodeableConcept
from .detected_issue_evidence import DetectedIssueEvidence
from .detected_issue_mitigation import DetectedIssueMitigation
from .detected_issue_severity import DetectedIssueSeverity
from .identifier import Identifier
from .period import Period
from .reference import Reference
from .uri import Uri

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class DetectedIssue(BaseResource):
    """
    Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. Drug-drug interaction, Ineffective treatment frequency, Procedure-condition conflict, etc.
    """

    resource_type: typing.Literal["DetectedIssue"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None, description="Business identifier associated with the detected issue record."
    )
    status: typing.Optional[Code] = pydantic.Field(
        default=None, description="Indicates the status of the detected issue."
    )
    code: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None, description="Identifies the general type of issue identified."
    )
    severity: typing.Optional[DetectedIssueSeverity] = pydantic.Field(
        default=None,
        description="Indicates the degree of importance associated with the identified issue based on the potential impact on the patient.",
    )
    patient: typing.Optional[Reference] = pydantic.Field(
        default=None, description="Indicates the patient whose record the detected issue is associated with."
    )
    identified_date_time: typing.Optional[str] = pydantic.Field(
        alias="identifiedDateTime",
        default=None,
        description="The date or period when the detected issue was initially identified.",
    )
    identified_period: typing.Optional[Period] = pydantic.Field(
        alias="identifiedPeriod",
        default=None,
        description="The date or period when the detected issue was initially identified.",
    )
    author: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="Individual or device responsible for the issue being raised. For example, a decision support application or a pharmacist conducting a medication review.",
    )
    implicated: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None,
        description="Indicates the resource representing the current activity or proposed activity that is potentially problematic.",
    )
    evidence: typing.Optional[typing.List[DetectedIssueEvidence]] = pydantic.Field(
        default=None,
        description="Supporting evidence or manifestations that provide the basis for identifying the detected issue such as a GuidanceResponse or MeasureReport.",
    )
    detail: typing.Optional[str] = pydantic.Field(
        default=None, description="A textual explanation of the detected issue."
    )
    reference: typing.Optional[Uri] = pydantic.Field(
        default=None,
        description="The literature, knowledge-base or similar reference that describes the propensity for the detected issue identified.",
    )
    mitigation: typing.Optional[typing.List[DetectedIssueMitigation]] = pydantic.Field(
        default=None,
        description="Indicates an action that has been taken or is committed to reduce or eliminate the likelihood of the risk identified by the detected issue from manifesting. Can also reflect an observation of known mitigating factors that may reduce/eliminate the need for any action.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
