# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .device_metric_calibration import DeviceMetricCalibration
from .device_metric_category import DeviceMetricCategory
from .device_metric_color import DeviceMetricColor
from .device_metric_operational_status import DeviceMetricOperationalStatus
from .identifier import Identifier
from .reference import Reference
from .timing import Timing

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class DeviceMetric(BaseResource):
    """
    Describes a measurement, calculation or setting capability of a medical device.
    """

    resource_type: typing.Literal["DeviceMetric"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None,
        description="Unique instance identifiers assigned to a device by the device or gateway software, manufacturers, other organizations or owners. For example: handle ID.",
    )
    type: CodeableConcept = pydantic.Field(
        description="Describes the type of the metric. For example: Heart Rate, PEEP Setting, etc."
    )
    unit: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None,
        description="Describes the unit that an observed value determined for this metric will have. For example: Percent, Seconds, etc.",
    )
    source: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="Describes the link to the Device that this DeviceMetric belongs to and that contains administrative device information such as manufacturer, serial number, etc.",
    )
    parent: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="Describes the link to the Device that this DeviceMetric belongs to and that provide information about the location of this DeviceMetric in the containment structure of the parent Device. An example would be a Device that represents a Channel. This reference can be used by a client application to distinguish DeviceMetrics that have the same type, but should be interpreted based on their containment location.",
    )
    operational_status: typing.Optional[DeviceMetricOperationalStatus] = pydantic.Field(
        alias="operationalStatus",
        default=None,
        description="Indicates current operational state of the device. For example: On, Off, Standby, etc.",
    )
    color: typing.Optional[DeviceMetricColor] = pydantic.Field(
        default=None,
        description="Describes the color representation for the metric. This is often used to aid clinicians to track and identify parameter types by color. In practice, consider a Patient Monitor that has ECG/HR and Pleth for example; the parameters are displayed in different characteristic colors, such as HR-blue, BP-green, and PR and SpO2- magenta.",
    )
    category: typing.Optional[DeviceMetricCategory] = pydantic.Field(
        default=None,
        description="Indicates the category of the observation generation process. A DeviceMetric can be for example a setting, measurement, or calculation.",
    )
    measurement_period: typing.Optional[Timing] = pydantic.Field(
        alias="measurementPeriod",
        default=None,
        description="Describes the measurement repetition time. This is not necessarily the same as the update period. The measurement repetition time can range from milliseconds up to hours. An example for a measurement repetition time in the range of milliseconds is the sampling rate of an ECG. An example for a measurement repetition time in the range of hours is a NIBP that is triggered automatically every hour. The update period may be different than the measurement repetition time, if the device does not update the published observed value with the same frequency as it was measured.",
    )
    calibration: typing.Optional[typing.List[DeviceMetricCalibration]] = pydantic.Field(
        default=None,
        description="Describes the calibrations that have been performed or that are required to be performed.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
