# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class DeviceMetricColor(str, enum.Enum):
    """
    Describes the color representation for the metric. This is often used to aid clinicians to track and identify parameter types by color. In practice, consider a Patient Monitor that has ECG/HR and Pleth for example; the parameters are displayed in different characteristic colors, such as HR-blue, BP-green, and PR and SpO2- magenta.
    """

    BLACK = "black"
    RED = "red"
    GREEN = "green"
    YELLOW = "yellow"
    BLUE = "blue"
    MAGENTA = "magenta"
    CYAN = "cyan"
    WHITE = "white"

    def visit(
        self,
        black: typing.Callable[[], T_Result],
        red: typing.Callable[[], T_Result],
        green: typing.Callable[[], T_Result],
        yellow: typing.Callable[[], T_Result],
        blue: typing.Callable[[], T_Result],
        magenta: typing.Callable[[], T_Result],
        cyan: typing.Callable[[], T_Result],
        white: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is DeviceMetricColor.BLACK:
            return black()
        if self is DeviceMetricColor.RED:
            return red()
        if self is DeviceMetricColor.GREEN:
            return green()
        if self is DeviceMetricColor.YELLOW:
            return yellow()
        if self is DeviceMetricColor.BLUE:
            return blue()
        if self is DeviceMetricColor.MAGENTA:
            return magenta()
        if self is DeviceMetricColor.CYAN:
            return cyan()
        if self is DeviceMetricColor.WHITE:
            return white()
