# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class DeviceMetricOperationalStatus(str, enum.Enum):
    """
    Indicates current operational state of the device. For example: On, Off, Standby, etc.
    """

    ON = "on"
    OFF = "off"
    STANDBY = "standby"
    ENTERED_IN_ERROR = "entered-in-error"

    def visit(
        self,
        on: typing.Callable[[], T_Result],
        off: typing.Callable[[], T_Result],
        standby: typing.Callable[[], T_Result],
        entered_in_error: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is DeviceMetricOperationalStatus.ON:
            return on()
        if self is DeviceMetricOperationalStatus.OFF:
            return off()
        if self is DeviceMetricOperationalStatus.STANDBY:
            return standby()
        if self is DeviceMetricOperationalStatus.ENTERED_IN_ERROR:
            return entered_in_error()
