# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class DeviceUdiCarrierEntryType(str, enum.Enum):
    """
    A coded entry to indicate how the data was entered.
    """

    BARCODE = "barcode"
    RFID = "rfid"
    MANUAL = "manual"
    CARD = "card"
    SELF_REPORTED = "self-reported"
    UNKNOWN = "unknown"

    def visit(
        self,
        barcode: typing.Callable[[], T_Result],
        rfid: typing.Callable[[], T_Result],
        manual: typing.Callable[[], T_Result],
        card: typing.Callable[[], T_Result],
        self_reported: typing.Callable[[], T_Result],
        unknown: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is DeviceUdiCarrierEntryType.BARCODE:
            return barcode()
        if self is DeviceUdiCarrierEntryType.RFID:
            return rfid()
        if self is DeviceUdiCarrierEntryType.MANUAL:
            return manual()
        if self is DeviceUdiCarrierEntryType.CARD:
            return card()
        if self is DeviceUdiCarrierEntryType.SELF_REPORTED:
            return self_reported()
        if self is DeviceUdiCarrierEntryType.UNKNOWN:
            return unknown()
