# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .annotation import Annotation
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .date_time import DateTime
from .device_use_statement_status import DeviceUseStatementStatus
from .identifier import Identifier
from .period import Period
from .reference import Reference
from .timing import Timing

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class DeviceUseStatement(BaseResource):
    """
    A record of a device being used by a patient where the record is the result of a report from the patient or another clinician.
    """

    resource_type: typing.Literal["DeviceUseStatement"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None, description="An external identifier for this statement such as an IRI."
    )
    based_on: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="basedOn",
        default=None,
        description="A plan, proposal or order that is fulfilled in whole or in part by this DeviceUseStatement.",
    )
    status: typing.Optional[DeviceUseStatementStatus] = pydantic.Field(
        default=None,
        description="A code representing the patient or other source's judgment about the state of the device used that this statement is about. Generally this will be active or completed.",
    )
    subject: Reference = pydantic.Field(description="The patient who used the device.")
    derived_from: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="derivedFrom",
        default=None,
        description="Allows linking the DeviceUseStatement to the underlying Request, or to other information that supports or is used to derive the DeviceUseStatement.",
    )
    timing_timing: typing.Optional[Timing] = pydantic.Field(
        alias="timingTiming", default=None, description="How often the device was used."
    )
    timing_period: typing.Optional[Period] = pydantic.Field(
        alias="timingPeriod", default=None, description="How often the device was used."
    )
    timing_date_time: typing.Optional[str] = pydantic.Field(
        alias="timingDateTime", default=None, description="How often the device was used."
    )
    recorded_on: typing.Optional[DateTime] = pydantic.Field(
        alias="recordedOn", default=None, description="The time at which the statement was made/recorded."
    )
    source: typing.Optional[Reference] = pydantic.Field(
        default=None, description="Who reported the device was being used by the patient."
    )
    device: Reference = pydantic.Field(description="The details of the device used.")
    reason_code: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        alias="reasonCode", default=None, description="Reason or justification for the use of the device."
    )
    reason_reference: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="reasonReference",
        default=None,
        description="Indicates another resource whose existence justifies this DeviceUseStatement.",
    )
    body_site: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="bodySite",
        default=None,
        description="Indicates the anotomic location on the subject's body where the device was used ( i.e. the target).",
    )
    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(
        default=None,
        description="Details about the device statement that were not represented at all or sufficiently in one of the attributes provided in a class. These may include for example a comment, an instruction, or a note associated with the statement.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
