# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class DiagnosticReportStatus(str, enum.Enum):
    """
    The status of the diagnostic report.
    """

    REGISTERED = "registered"
    PARTIAL = "partial"
    PRELIMINARY = "preliminary"
    FINAL = "final"
    AMENDED = "amended"
    CORRECTED = "corrected"
    APPENDED = "appended"
    CANCELLED = "cancelled"
    ENTERED_IN_ERROR = "entered-in-error"
    UNKNOWN = "unknown"

    def visit(
        self,
        registered: typing.Callable[[], T_Result],
        partial: typing.Callable[[], T_Result],
        preliminary: typing.Callable[[], T_Result],
        final: typing.Callable[[], T_Result],
        amended: typing.Callable[[], T_Result],
        corrected: typing.Callable[[], T_Result],
        appended: typing.Callable[[], T_Result],
        cancelled: typing.Callable[[], T_Result],
        entered_in_error: typing.Callable[[], T_Result],
        unknown: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is DiagnosticReportStatus.REGISTERED:
            return registered()
        if self is DiagnosticReportStatus.PARTIAL:
            return partial()
        if self is DiagnosticReportStatus.PRELIMINARY:
            return preliminary()
        if self is DiagnosticReportStatus.FINAL:
            return final()
        if self is DiagnosticReportStatus.AMENDED:
            return amended()
        if self is DiagnosticReportStatus.CORRECTED:
            return corrected()
        if self is DiagnosticReportStatus.APPENDED:
            return appended()
        if self is DiagnosticReportStatus.CANCELLED:
            return cancelled()
        if self is DiagnosticReportStatus.ENTERED_IN_ERROR:
            return entered_in_error()
        if self is DiagnosticReportStatus.UNKNOWN:
            return unknown()
