# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .annotation import Annotation
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .contact_detail import ContactDetail
from .date_time import DateTime
from .effect_evidence_synthesis_certainty import EffectEvidenceSynthesisCertainty
from .effect_evidence_synthesis_effect_estimate import EffectEvidenceSynthesisEffectEstimate
from .effect_evidence_synthesis_results_by_exposure import EffectEvidenceSynthesisResultsByExposure
from .effect_evidence_synthesis_sample_size import EffectEvidenceSynthesisSampleSize
from .effect_evidence_synthesis_status import EffectEvidenceSynthesisStatus
from .identifier import Identifier
from .markdown import Markdown
from .period import Period
from .reference import Reference
from .related_artifact import RelatedArtifact
from .uri import Uri
from .usage_context import UsageContext

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class EffectEvidenceSynthesis(BaseResource):
    """
    The EffectEvidenceSynthesis resource describes the difference in an outcome between exposures states in a population where the effect estimate is derived from a combination of research studies.
    """

    resource_type: typing.Literal["EffectEvidenceSynthesis"] = pydantic.Field(alias="resourceType")
    url: typing.Optional[Uri] = pydantic.Field(
        default=None,
        description="An absolute URI that is used to identify this effect evidence synthesis when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this effect evidence synthesis is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the effect evidence synthesis is stored on different servers.",
    )
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None,
        description="A formal identifier that is used to identify this effect evidence synthesis when it is represented in other formats, or referenced in a specification, model, design or an instance.",
    )
    version: typing.Optional[str] = pydantic.Field(
        default=None,
        description="The identifier that is used to identify this version of the effect evidence synthesis when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the effect evidence synthesis author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.",
    )
    name: typing.Optional[str] = pydantic.Field(
        default=None,
        description="A natural language name identifying the effect evidence synthesis. This name should be usable as an identifier for the module by machine processing applications such as code generation.",
    )
    title: typing.Optional[str] = pydantic.Field(
        default=None, description="A short, descriptive, user-friendly title for the effect evidence synthesis."
    )
    status: typing.Optional[EffectEvidenceSynthesisStatus] = pydantic.Field(
        default=None,
        description="The status of this effect evidence synthesis. Enables tracking the life-cycle of the content.",
    )
    date: typing.Optional[DateTime] = pydantic.Field(
        default=None,
        description="The date (and optionally time) when the effect evidence synthesis was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the effect evidence synthesis changes.",
    )
    publisher: typing.Optional[str] = pydantic.Field(
        default=None,
        description="The name of the organization or individual that published the effect evidence synthesis.",
    )
    contact: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(
        default=None, description="Contact details to assist a user in finding and communicating with the publisher."
    )
    description: typing.Optional[Markdown] = pydantic.Field(
        default=None,
        description="A free text natural language description of the effect evidence synthesis from a consumer's perspective.",
    )
    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(
        default=None, description="A human-readable string to clarify or explain concepts about the resource."
    )
    use_context: typing.Optional[typing.List[UsageContext]] = pydantic.Field(
        alias="useContext",
        default=None,
        description="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate effect evidence synthesis instances.",
    )
    jurisdiction: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None,
        description="A legal or geographic region in which the effect evidence synthesis is intended to be used.",
    )
    copyright: typing.Optional[Markdown] = pydantic.Field(
        default=None,
        description="A copyright statement relating to the effect evidence synthesis and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the effect evidence synthesis.",
    )
    approval_date: typing.Optional[dt.date] = pydantic.Field(
        alias="approvalDate",
        default=None,
        description="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.",
    )
    last_review_date: typing.Optional[dt.date] = pydantic.Field(
        alias="lastReviewDate",
        default=None,
        description="The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.",
    )
    effective_period: typing.Optional[Period] = pydantic.Field(
        alias="effectivePeriod",
        default=None,
        description="The period during which the effect evidence synthesis content was or is planned to be in active use.",
    )
    topic: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None,
        description="Descriptive topics related to the content of the EffectEvidenceSynthesis. Topics provide a high-level categorization grouping types of EffectEvidenceSynthesiss that can be useful for filtering and searching.",
    )
    author: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(
        default=None,
        description="An individiual or organization primarily involved in the creation and maintenance of the content.",
    )
    editor: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(
        default=None,
        description="An individual or organization primarily responsible for internal coherence of the content.",
    )
    reviewer: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(
        default=None,
        description="An individual or organization primarily responsible for review of some aspect of the content.",
    )
    endorser: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(
        default=None,
        description="An individual or organization responsible for officially endorsing the content for use in some setting.",
    )
    related_artifact: typing.Optional[typing.List[RelatedArtifact]] = pydantic.Field(
        alias="relatedArtifact",
        default=None,
        description="Related artifacts such as additional documentation, justification, or bibliographic references.",
    )
    synthesis_type: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="synthesisType", default=None, description="Type of synthesis eg meta-analysis."
    )
    study_type: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="studyType", default=None, description="Type of study eg randomized trial."
    )
    population: Reference = pydantic.Field(
        description="A reference to a EvidenceVariable resource that defines the population for the research."
    )
    exposure: Reference = pydantic.Field(
        description="A reference to a EvidenceVariable resource that defines the exposure for the research."
    )
    exposure_alternative: Reference = pydantic.Field(
        alias="exposureAlternative",
        description="A reference to a EvidenceVariable resource that defines the comparison exposure for the research.",
    )
    outcome: Reference = pydantic.Field(
        description="A reference to a EvidenceVariable resomece that defines the outcome for the research."
    )
    sample_size: typing.Optional[EffectEvidenceSynthesisSampleSize] = pydantic.Field(
        alias="sampleSize",
        default=None,
        description="A description of the size of the sample involved in the synthesis.",
    )
    results_by_exposure: typing.Optional[typing.List[EffectEvidenceSynthesisResultsByExposure]] = pydantic.Field(
        alias="resultsByExposure",
        default=None,
        description="A description of the results for each exposure considered in the effect estimate.",
    )
    effect_estimate: typing.Optional[typing.List[EffectEvidenceSynthesisEffectEstimate]] = pydantic.Field(
        alias="effectEstimate", default=None, description="The estimated effect of the exposure variant."
    )
    certainty: typing.Optional[typing.List[EffectEvidenceSynthesisCertainty]] = pydantic.Field(
        default=None, description="A description of the certainty of the effect estimate."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
