# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class EncounterLocationStatus(str, enum.Enum):
    """
    The status of the participants' presence at the specified location during the period specified. If the participant is no longer at the location, then the period will have an end date/time.
    """

    PLANNED = "planned"
    ACTIVE = "active"
    RESERVED = "reserved"
    COMPLETED = "completed"

    def visit(
        self,
        planned: typing.Callable[[], T_Result],
        active: typing.Callable[[], T_Result],
        reserved: typing.Callable[[], T_Result],
        completed: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is EncounterLocationStatus.PLANNED:
            return planned()
        if self is EncounterLocationStatus.ACTIVE:
            return active()
        if self is EncounterLocationStatus.RESERVED:
            return reserved()
        if self is EncounterLocationStatus.COMPLETED:
            return completed()
