# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class EncounterStatus(str, enum.Enum):
    """
    planned | arrived | triaged | in-progress | onleave | finished | cancelled +.
    """

    PLANNED = "planned"
    ARRIVED = "arrived"
    TRIAGED = "triaged"
    IN_PROGRESS = "in-progress"
    ONLEAVE = "onleave"
    FINISHED = "finished"
    CANCELLED = "cancelled"
    ENTERED_IN_ERROR = "entered-in-error"
    UNKNOWN = "unknown"

    def visit(
        self,
        planned: typing.Callable[[], T_Result],
        arrived: typing.Callable[[], T_Result],
        triaged: typing.Callable[[], T_Result],
        in_progress: typing.Callable[[], T_Result],
        onleave: typing.Callable[[], T_Result],
        finished: typing.Callable[[], T_Result],
        cancelled: typing.Callable[[], T_Result],
        entered_in_error: typing.Callable[[], T_Result],
        unknown: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is EncounterStatus.PLANNED:
            return planned()
        if self is EncounterStatus.ARRIVED:
            return arrived()
        if self is EncounterStatus.TRIAGED:
            return triaged()
        if self is EncounterStatus.IN_PROGRESS:
            return in_progress()
        if self is EncounterStatus.ONLEAVE:
            return onleave()
        if self is EncounterStatus.FINISHED:
            return finished()
        if self is EncounterStatus.CANCELLED:
            return cancelled()
        if self is EncounterStatus.ENTERED_IN_ERROR:
            return entered_in_error()
        if self is EncounterStatus.UNKNOWN:
            return unknown()
