# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .code import Code
from .date_time import DateTime
from .identifier import Identifier
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class EnrollmentRequest(BaseResource):
    """
    This resource provides the insurance enrollment details to the insurer regarding a specified coverage.
    """

    resource_type: typing.Literal["EnrollmentRequest"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None, description="The Response business identifier."
    )
    status: typing.Optional[Code] = pydantic.Field(default=None, description="The status of the resource instance.")
    created: typing.Optional[DateTime] = pydantic.Field(
        default=None, description="The date when this resource was created."
    )
    insurer: typing.Optional[Reference] = pydantic.Field(
        default=None, description="The Insurer who is target of the request."
    )
    provider: typing.Optional[Reference] = pydantic.Field(
        default=None, description="The practitioner who is responsible for the services rendered to the patient."
    )
    candidate: typing.Optional[Reference] = pydantic.Field(default=None, description="Patient Resource.")
    coverage: typing.Optional[Reference] = pydantic.Field(
        default=None, description="Reference to the program or plan identification, underwriter or payor."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
