# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .code import Code
from .date_time import DateTime
from .enrollment_response_outcome import EnrollmentResponseOutcome
from .identifier import Identifier
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class EnrollmentResponse(BaseResource):
    """
    This resource provides enrollment and plan details from the processing of an EnrollmentRequest resource.
    """

    resource_type: typing.Literal["EnrollmentResponse"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None, description="The Response business identifier."
    )
    status: typing.Optional[Code] = pydantic.Field(default=None, description="The status of the resource instance.")
    request: typing.Optional[Reference] = pydantic.Field(
        default=None, description="Original request resource reference."
    )
    outcome: typing.Optional[EnrollmentResponseOutcome] = pydantic.Field(
        default=None, description="Processing status: error, complete."
    )
    disposition: typing.Optional[str] = pydantic.Field(
        default=None, description="A description of the status of the adjudication."
    )
    created: typing.Optional[DateTime] = pydantic.Field(
        default=None, description="The date when the enclosed suite of services were performed or completed."
    )
    organization: typing.Optional[Reference] = pydantic.Field(
        default=None, description="The Insurer who produced this adjudicated response."
    )
    request_provider: typing.Optional[Reference] = pydantic.Field(
        alias="requestProvider",
        default=None,
        description="The practitioner who is responsible for the services rendered to the patient.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
