# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .expression_language import ExpressionLanguage
from .id import Id
from .uri import Uri

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Expression(pydantic.BaseModel):
    """
    A expression that is evaluated in a specified context and returns a value. The context of use of the expression must specify the context in which the expression is evaluated, and how the result of the expression is used.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    description: typing.Optional[str] = pydantic.Field(
        default=None,
        description="A brief, natural language description of the condition that effectively communicates the intended semantics.",
    )
    name: typing.Optional[Id] = pydantic.Field(
        default=None,
        description="A short name assigned to the expression to allow for multiple reuse of the expression in the context where it is defined.",
    )
    language: typing.Optional[ExpressionLanguage] = pydantic.Field(
        default=None, description="The media type of the language for the expression."
    )
    expression: typing.Optional[str] = pydantic.Field(
        default=None, description="An expression in the specified language that returns a value."
    )
    reference: typing.Optional[Uri] = pydantic.Field(
        default=None, description="A URI that defines where the expression is found."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}


from .extension import Extension  # noqa: E402

Expression.update_forward_refs()
