# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ExpressionLanguage(str, enum.Enum):
    """
    The media type of the language for the expression.
    """

    TEXT_CQL = "text/cql"
    TEXT_FHIRPATH = "text/fhirpath"
    APPLICATION_X_FHIR_QUERY = "application/x-fhir-query"

    def visit(
        self,
        text_cql: typing.Callable[[], T_Result],
        text_fhirpath: typing.Callable[[], T_Result],
        application_x_fhir_query: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is ExpressionLanguage.TEXT_CQL:
            return text_cql()
        if self is ExpressionLanguage.TEXT_FHIRPATH:
            return text_fhirpath()
        if self is ExpressionLanguage.APPLICATION_X_FHIR_QUERY:
            return application_x_fhir_query()
