# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class FamilyMemberHistoryStatus(str, enum.Enum):
    """
    A code specifying the status of the record of the family history of a specific family member.
    """

    PARTIAL = "partial"
    COMPLETED = "completed"
    ENTERED_IN_ERROR = "entered-in-error"
    HEALTH_UNKNOWN = "health-unknown"

    def visit(
        self,
        partial: typing.Callable[[], T_Result],
        completed: typing.Callable[[], T_Result],
        entered_in_error: typing.Callable[[], T_Result],
        health_unknown: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is FamilyMemberHistoryStatus.PARTIAL:
            return partial()
        if self is FamilyMemberHistoryStatus.COMPLETED:
            return completed()
        if self is FamilyMemberHistoryStatus.ENTERED_IN_ERROR:
            return entered_in_error()
        if self is FamilyMemberHistoryStatus.HEALTH_UNKNOWN:
            return health_unknown()
