# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .annotation import Annotation
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .goal_lifecycle_status import GoalLifecycleStatus
from .goal_target import GoalTarget
from .identifier import Identifier
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Goal(BaseResource):
    """
    Describes the intended objective(s) for a patient, group or organization care, for example, weight loss, restoring an activity of daily living, obtaining herd immunity via immunization, meeting a process improvement objective, etc.
    """

    resource_type: typing.Literal["Goal"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None,
        description="Business identifiers assigned to this goal by the performer or other systems which remain constant as the resource is updated and propagates from server to server.",
    )
    lifecycle_status: typing.Optional[GoalLifecycleStatus] = pydantic.Field(
        alias="lifecycleStatus", default=None, description="The state of the goal throughout its lifecycle."
    )
    achievement_status: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="achievementStatus",
        default=None,
        description="Describes the progression, or lack thereof, towards the goal against the target.",
    )
    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None, description="Indicates a category the goal falls within."
    )
    priority: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None,
        description="Identifies the mutually agreed level of importance associated with reaching/sustaining the goal.",
    )
    description: CodeableConcept = pydantic.Field(
        description='Human-readable and/or coded description of a specific desired objective of care, such as "control blood pressure" or "negotiate an obstacle course" or "dance with child at wedding".'
    )
    subject: Reference = pydantic.Field(
        description="Identifies the patient, group or organization for whom the goal is being established."
    )
    start_date: typing.Optional[str] = pydantic.Field(
        alias="startDate",
        default=None,
        description="The date or event after which the goal should begin being pursued.",
    )
    start_codeable_concept: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="startCodeableConcept",
        default=None,
        description="The date or event after which the goal should begin being pursued.",
    )
    target: typing.Optional[typing.List[GoalTarget]] = pydantic.Field(
        default=None, description="Indicates what should be done by when."
    )
    status_date: typing.Optional[dt.date] = pydantic.Field(
        alias="statusDate",
        default=None,
        description="Identifies when the current status. I.e. When initially created, when achieved, when cancelled, etc.",
    )
    status_reason: typing.Optional[str] = pydantic.Field(
        alias="statusReason", default=None, description="Captures the reason for the current status."
    )
    expressed_by: typing.Optional[Reference] = pydantic.Field(
        alias="expressedBy",
        default=None,
        description="Indicates whose goal this is - patient goal, practitioner goal, etc.",
    )
    addresses: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None,
        description="The identified conditions and other health record elements that are intended to be addressed by the goal.",
    )
    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(
        default=None, description="Any comments related to the goal."
    )
    outcome_code: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        alias="outcomeCode",
        default=None,
        description="Identifies the change (or lack of change) at the point when the status of the goal is assessed.",
    )
    outcome_reference: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="outcomeReference", default=None, description="Details of what's changed (or not changed)."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
