# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class GoalLifecycleStatus(str, enum.Enum):
    """
    The state of the goal throughout its lifecycle.
    """

    PROPOSED = "proposed"
    PLANNED = "planned"
    ACCEPTED = "accepted"
    ACTIVE = "active"
    ON_HOLD = "on-hold"
    COMPLETED = "completed"
    CANCELLED = "cancelled"
    ENTERED_IN_ERROR = "entered-in-error"
    REJECTED = "rejected"

    def visit(
        self,
        proposed: typing.Callable[[], T_Result],
        planned: typing.Callable[[], T_Result],
        accepted: typing.Callable[[], T_Result],
        active: typing.Callable[[], T_Result],
        on_hold: typing.Callable[[], T_Result],
        completed: typing.Callable[[], T_Result],
        cancelled: typing.Callable[[], T_Result],
        entered_in_error: typing.Callable[[], T_Result],
        rejected: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is GoalLifecycleStatus.PROPOSED:
            return proposed()
        if self is GoalLifecycleStatus.PLANNED:
            return planned()
        if self is GoalLifecycleStatus.ACCEPTED:
            return accepted()
        if self is GoalLifecycleStatus.ACTIVE:
            return active()
        if self is GoalLifecycleStatus.ON_HOLD:
            return on_hold()
        if self is GoalLifecycleStatus.COMPLETED:
            return completed()
        if self is GoalLifecycleStatus.CANCELLED:
            return cancelled()
        if self is GoalLifecycleStatus.ENTERED_IN_ERROR:
            return entered_in_error()
        if self is GoalLifecycleStatus.REJECTED:
            return rejected()
