# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class GroupType(str, enum.Enum):
    """
    Identifies the broad classification of the kind of resources the group includes.
    """

    PERSON = "person"
    ANIMAL = "animal"
    PRACTITIONER = "practitioner"
    DEVICE = "device"
    MEDICATION = "medication"
    SUBSTANCE = "substance"

    def visit(
        self,
        person: typing.Callable[[], T_Result],
        animal: typing.Callable[[], T_Result],
        practitioner: typing.Callable[[], T_Result],
        device: typing.Callable[[], T_Result],
        medication: typing.Callable[[], T_Result],
        substance: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is GroupType.PERSON:
            return person()
        if self is GroupType.ANIMAL:
            return animal()
        if self is GroupType.PRACTITIONER:
            return practitioner()
        if self is GroupType.DEVICE:
            return device()
        if self is GroupType.MEDICATION:
            return medication()
        if self is GroupType.SUBSTANCE:
            return substance()
