# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .annotation import Annotation
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .data_requirement import DataRequirement
from .date_time import DateTime
from .guidance_response_status import GuidanceResponseStatus
from .identifier import Identifier
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class GuidanceResponse(BaseResource):
    """
    A guidance response is the formal response to a guidance request, including any output parameters returned by the evaluation, as well as the description of any proposed actions to be taken.
    """

    resource_type: typing.Literal["GuidanceResponse"] = pydantic.Field(alias="resourceType")
    request_identifier: typing.Optional[Identifier] = pydantic.Field(
        alias="requestIdentifier",
        default=None,
        description="The identifier of the request associated with this response. If an identifier was given as part of the request, it will be reproduced here to enable the requester to more easily identify the response in a multi-request scenario.",
    )
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None, description="Allows a service to provide unique, business identifiers for the response."
    )
    module_uri: typing.Optional[str] = pydantic.Field(
        alias="moduleUri",
        default=None,
        description="An identifier, CodeableConcept or canonical reference to the guidance that was requested.",
    )
    module_canonical: typing.Optional[str] = pydantic.Field(
        alias="moduleCanonical",
        default=None,
        description="An identifier, CodeableConcept or canonical reference to the guidance that was requested.",
    )
    module_codeable_concept: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="moduleCodeableConcept",
        default=None,
        description="An identifier, CodeableConcept or canonical reference to the guidance that was requested.",
    )
    status: typing.Optional[GuidanceResponseStatus] = pydantic.Field(
        default=None,
        description="The status of the response. If the evaluation is completed successfully, the status will indicate success. However, in order to complete the evaluation, the engine may require more information. In this case, the status will be data-required, and the response will contain a description of the additional required information. If the evaluation completed successfully, but the engine determines that a potentially more accurate response could be provided if more data was available, the status will be data-requested, and the response will contain a description of the additional requested information.",
    )
    subject: typing.Optional[Reference] = pydantic.Field(
        default=None, description="The patient for which the request was processed."
    )
    encounter: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="The encounter during which this response was created or to which the creation of this record is tightly associated.",
    )
    occurrence_date_time: typing.Optional[DateTime] = pydantic.Field(
        alias="occurrenceDateTime", default=None, description="Indicates when the guidance response was processed."
    )
    performer: typing.Optional[Reference] = pydantic.Field(
        default=None, description="Provides a reference to the device that performed the guidance."
    )
    reason_code: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        alias="reasonCode",
        default=None,
        description="Describes the reason for the guidance response in coded or textual form.",
    )
    reason_reference: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="reasonReference",
        default=None,
        description="Indicates the reason the request was initiated. This is typically provided as a parameter to the evaluation and echoed by the service, although for some use cases, such as subscription- or event-based scenarios, it may provide an indication of the cause for the response.",
    )
    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(
        default=None, description="Provides a mechanism to communicate additional information about the response."
    )
    evaluation_message: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="evaluationMessage",
        default=None,
        description="Messages resulting from the evaluation of the artifact or artifacts. As part of evaluating the request, the engine may produce informational or warning messages. These messages will be provided by this element.",
    )
    output_parameters: typing.Optional[Reference] = pydantic.Field(
        alias="outputParameters",
        default=None,
        description="The output parameters of the evaluation, if any. Many modules will result in the return of specific resources such as procedure or communication requests that are returned as part of the operation result. However, modules may define specific outputs that would be returned as the result of the evaluation, and these would be returned in this element.",
    )
    result: typing.Optional[Reference] = pydantic.Field(
        default=None, description="The actions, if any, produced by the evaluation of the artifact."
    )
    data_requirement: typing.Optional[typing.List[DataRequirement]] = pydantic.Field(
        alias="dataRequirement",
        default=None,
        description="If the evaluation could not be completed due to lack of information, or additional information would potentially result in a more accurate response, this element will a description of the data required in order to proceed with the evaluation. A subsequent request to the service should include this data.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
