# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .identifier_use import IdentifierUse
from .uri import Uri

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Identifier(pydantic.BaseModel):
    """
    An identifier - identifies some entity uniquely and unambiguously. Typically this is used for business identifiers.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    use: typing.Optional[IdentifierUse] = pydantic.Field(default=None, description="The purpose of this identifier.")
    type: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None,
        description="A coded type for the identifier that can be used to determine which identifier to use for a specific purpose.",
    )
    system: typing.Optional[Uri] = pydantic.Field(
        default=None,
        description="Establishes the namespace for the value - that is, a URL that describes a set values that are unique.",
    )
    value: typing.Optional[str] = pydantic.Field(
        default=None,
        description="The portion of the identifier typically relevant to the user and which is unique within the context of the system.",
    )
    period: typing.Optional[Period] = pydantic.Field(
        default=None, description="Time period during which identifier is/was valid for use."
    )
    assigner: typing.Optional[Reference] = pydantic.Field(
        default=None, description="Organization that issued/manages the identifier."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        json_encoders = {dt.datetime: serialize_datetime}


from .codeable_concept import CodeableConcept  # noqa: E402
from .extension import Extension  # noqa: E402
from .period import Period  # noqa: E402
from .reference import Reference  # noqa: E402

Identifier.update_forward_refs()
