# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class IdentityProvider(pydantic.BaseModel):
    """
    External Identity Provider (IdP) configuration details.
    """

    authorize_url: str = pydantic.Field(
        alias="authorizeUrl", description="Remote URL for the external Identity Provider authorize endpoint."
    )
    token_url: str = pydantic.Field(
        alias="tokenUrl", description="Remote URL for the external Identity Provider token endpoint."
    )
    user_info_url: str = pydantic.Field(
        alias="userInfoUrl", description="Remote URL for the external Identity Provider userinfo endpoint."
    )
    client_id: str = pydantic.Field(alias="clientId", description="External Identity Provider client ID.")
    client_secret: str = pydantic.Field(alias="clientSecret", description="External Identity Provider client secret.")
    use_subject: typing.Optional[bool] = pydantic.Field(
        alias="useSubject",
        default=None,
        description="Optional flag to use the subject field instead of the email field.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
