# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .coding import Coding
from .date_time import DateTime
from .extension import Extension
from .id import Id
from .imaging_study_instance import ImagingStudyInstance
from .imaging_study_performer import ImagingStudyPerformer
from .reference import Reference
from .unsigned_int import UnsignedInt

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ImagingStudySeries(pydantic.BaseModel):
    """
    Representation of the content produced in a DICOM imaging study. A study comprises a set of series, each of which includes a set of Service-Object Pair Instances (SOP Instances - images or other data) acquired or produced in a common context. A series is of only one modality (e.g. X-ray, CT, MR, ultrasound), but a study may have multiple series of different modalities.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    modifier_extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        alias="modifierExtension",
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
    )
    uid: typing.Optional[Id] = pydantic.Field(default=None, description="The DICOM Series Instance UID for the series.")
    number: typing.Optional[UnsignedInt] = pydantic.Field(
        default=None, description="The numeric identifier of this series in the study."
    )
    modality: Coding = pydantic.Field(description="The modality of this series sequence.")
    description: typing.Optional[str] = pydantic.Field(default=None, description="A description of the series.")
    number_of_instances: typing.Optional[UnsignedInt] = pydantic.Field(
        alias="numberOfInstances",
        default=None,
        description="Number of SOP Instances in the Study. The value given may be larger than the number of instance elements this resource contains due to resource availability, security, or other factors. This element should be present if any instance elements are present.",
    )
    endpoint: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None,
        description="The network service providing access (e.g., query, view, or retrieval) for this series. See implementation notes for information about using DICOM endpoints. A series-level endpoint, if present, has precedence over a study-level endpoint with the same Endpoint.connectionType.",
    )
    body_site: typing.Optional[Coding] = pydantic.Field(
        alias="bodySite",
        default=None,
        description="The anatomic structures examined. See DICOM Part 16 Annex L (http://dicom.nema.org/medical/dicom/current/output/chtml/part16/chapter_L.html) for DICOM to SNOMED-CT mappings. The bodySite may indicate the laterality of body part imaged; if so, it shall be consistent with any content of ImagingStudy.series.laterality.",
    )
    laterality: typing.Optional[Coding] = pydantic.Field(
        default=None,
        description="The laterality of the (possibly paired) anatomic structures examined. E.g., the left knee, both lungs, or unpaired abdomen. If present, shall be consistent with any laterality information indicated in ImagingStudy.series.bodySite.",
    )
    specimen: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None, description="The specimen imaged, e.g., for whole slide imaging of a biopsy."
    )
    started: typing.Optional[DateTime] = pydantic.Field(
        default=None, description="The date and time the series was started."
    )
    performer: typing.Optional[typing.List[ImagingStudyPerformer]] = pydantic.Field(
        default=None, description="Indicates who or what performed the series and how they were involved."
    )
    instance: typing.Optional[typing.List[ImagingStudyInstance]] = pydantic.Field(
        default=None, description="A single SOP instance within the series, e.g. an image, or presentation state."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
