# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ImagingStudyStatus(str, enum.Enum):
    """
    The current state of the ImagingStudy.
    """

    REGISTERED = "registered"
    AVAILABLE = "available"
    CANCELLED = "cancelled"
    ENTERED_IN_ERROR = "entered-in-error"
    UNKNOWN = "unknown"

    def visit(
        self,
        registered: typing.Callable[[], T_Result],
        available: typing.Callable[[], T_Result],
        cancelled: typing.Callable[[], T_Result],
        entered_in_error: typing.Callable[[], T_Result],
        unknown: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is ImagingStudyStatus.REGISTERED:
            return registered()
        if self is ImagingStudyStatus.AVAILABLE:
            return available()
        if self is ImagingStudyStatus.CANCELLED:
            return cancelled()
        if self is ImagingStudyStatus.ENTERED_IN_ERROR:
            return entered_in_error()
        if self is ImagingStudyStatus.UNKNOWN:
            return unknown()
