# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .code import Code
from .codeable_concept import CodeableConcept
from .date_time import DateTime
from .identifier import Identifier
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ImmunizationEvaluation(BaseResource):
    """
    Describes a comparison of an immunization event against published recommendations to determine if the administration is "valid" in relation to those recommendations.
    """

    resource_type: typing.Literal["ImmunizationEvaluation"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None, description="A unique identifier assigned to this immunization evaluation record."
    )
    status: typing.Optional[Code] = pydantic.Field(
        default=None,
        description="Indicates the current status of the evaluation of the vaccination administration event.",
    )
    patient: Reference = pydantic.Field(description="The individual for whom the evaluation is being done.")
    date: typing.Optional[DateTime] = pydantic.Field(
        default=None, description="The date the evaluation of the vaccine administration event was performed."
    )
    authority: typing.Optional[Reference] = pydantic.Field(
        default=None, description="Indicates the authority who published the protocol (e.g. ACIP)."
    )
    target_disease: CodeableConcept = pydantic.Field(
        alias="targetDisease", description="The vaccine preventable disease the dose is being evaluated against."
    )
    immunization_event: Reference = pydantic.Field(
        alias="immunizationEvent", description="The vaccine administration event being evaluated."
    )
    dose_status: CodeableConcept = pydantic.Field(
        alias="doseStatus",
        description="Indicates if the dose is valid or not valid with respect to the published recommendations.",
    )
    dose_status_reason: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        alias="doseStatusReason",
        default=None,
        description="Provides an explanation as to why the vaccine administration event is valid or not relative to the published recommendations.",
    )
    description: typing.Optional[str] = pydantic.Field(
        default=None, description="Additional information about the evaluation."
    )
    series: typing.Optional[str] = pydantic.Field(
        default=None,
        description="One possible path to achieve presumed immunity against a disease - within the context of an authority.",
    )
    dose_number_positive_int: typing.Optional[float] = pydantic.Field(
        alias="doseNumberPositiveInt", default=None, description="Nominal position in a series."
    )
    dose_number_string: typing.Optional[str] = pydantic.Field(
        alias="doseNumberString", default=None, description="Nominal position in a series."
    )
    series_doses_positive_int: typing.Optional[float] = pydantic.Field(
        alias="seriesDosesPositiveInt", default=None, description="The recommended number of doses to achieve immunity."
    )
    series_doses_string: typing.Optional[str] = pydantic.Field(
        alias="seriesDosesString", default=None, description="The recommended number of doses to achieve immunity."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
