# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .date_time import DateTime
from .identifier import Identifier
from .immunization_recommendation_recommendation import ImmunizationRecommendationRecommendation
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class ImmunizationRecommendation(BaseResource):
    """
    A patient's point-in-time set of recommendations (i.e. forecasting) according to a published schedule with optional supporting justification.
    """

    resource_type: typing.Literal["ImmunizationRecommendation"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None, description="A unique identifier assigned to this particular recommendation record."
    )
    patient: Reference = pydantic.Field(description="The patient the recommendation(s) are for.")
    date: typing.Optional[DateTime] = pydantic.Field(
        default=None, description="The date the immunization recommendation(s) were created."
    )
    authority: typing.Optional[Reference] = pydantic.Field(
        default=None, description="Indicates the authority who published the protocol (e.g. ACIP)."
    )
    recommendation: typing.List[ImmunizationRecommendationRecommendation] = pydantic.Field(
        description="Vaccine administration recommendations."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
