# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class InsurancePlanStatus(str, enum.Enum):
    """
    The current state of the health insurance product.
    """

    DRAFT = "draft"
    ACTIVE = "active"
    RETIRED = "retired"
    UNKNOWN = "unknown"

    def visit(
        self,
        draft: typing.Callable[[], T_Result],
        active: typing.Callable[[], T_Result],
        retired: typing.Callable[[], T_Result],
        unknown: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is InsurancePlanStatus.DRAFT:
            return draft()
        if self is InsurancePlanStatus.ACTIVE:
            return active()
        if self is InsurancePlanStatus.RETIRED:
            return retired()
        if self is InsurancePlanStatus.UNKNOWN:
            return unknown()
