# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class InvoiceStatus(str, enum.Enum):
    """
    The current state of the Invoice.
    """

    DRAFT = "draft"
    ISSUED = "issued"
    BALANCED = "balanced"
    CANCELLED = "cancelled"
    ENTERED_IN_ERROR = "entered-in-error"

    def visit(
        self,
        draft: typing.Callable[[], T_Result],
        issued: typing.Callable[[], T_Result],
        balanced: typing.Callable[[], T_Result],
        cancelled: typing.Callable[[], T_Result],
        entered_in_error: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is InvoiceStatus.DRAFT:
            return draft()
        if self is InvoiceStatus.ISSUED:
            return issued()
        if self is InvoiceStatus.BALANCED:
            return balanced()
        if self is InvoiceStatus.CANCELLED:
            return cancelled()
        if self is InvoiceStatus.ENTERED_IN_ERROR:
            return entered_in_error()
