# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class LinkageItemType(str, enum.Enum):
    """
    Distinguishes which item is "source of truth" (if any) and which items are no longer considered to be current representations.
    """

    SOURCE = "source"
    ALTERNATE = "alternate"
    HISTORICAL = "historical"

    def visit(
        self,
        source: typing.Callable[[], T_Result],
        alternate: typing.Callable[[], T_Result],
        historical: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is LinkageItemType.SOURCE:
            return source()
        if self is LinkageItemType.ALTERNATE:
            return alternate()
        if self is LinkageItemType.HISTORICAL:
            return historical()
