# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ListMode(str, enum.Enum):
    """
    How this list was prepared - whether it is a working list that is suitable for being maintained on an ongoing basis, or if it represents a snapshot of a list of items from another source, or whether it is a prepared list where items may be marked as added, modified or deleted.
    """

    WORKING = "working"
    SNAPSHOT = "snapshot"
    CHANGES = "changes"

    def visit(
        self,
        working: typing.Callable[[], T_Result],
        snapshot: typing.Callable[[], T_Result],
        changes: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is ListMode.WORKING:
            return working()
        if self is ListMode.SNAPSHOT:
            return snapshot()
        if self is ListMode.CHANGES:
            return changes()
