# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .address import Address
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_point import ContactPoint
from .identifier import Identifier
from .location_hours_of_operation import LocationHoursOfOperation
from .location_mode import LocationMode
from .location_position import LocationPosition
from .location_status import LocationStatus
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Location(BaseResource):
    """
    Details and position information for a physical place where services are provided and resources and participants may be stored, found, contained, or accommodated.
    """

    resource_type: typing.Literal["Location"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None, description="Unique code or number identifying the location to its users."
    )
    status: typing.Optional[LocationStatus] = pydantic.Field(
        default=None,
        description="The status property covers the general availability of the resource, not the current value which may be covered by the operationStatus, or by a schedule/slots if they are configured for the location.",
    )
    operational_status: typing.Optional[Coding] = pydantic.Field(
        alias="operationalStatus",
        default=None,
        description="The operational status covers operation values most relevant to beds (but can also apply to rooms/units/chairs/etc. such as an isolation unit/dialysis chair). This typically covers concepts such as contamination, housekeeping, and other activities like maintenance.",
    )
    name: typing.Optional[str] = pydantic.Field(
        default=None, description="Name of the location as used by humans. Does not need to be unique."
    )
    alias: typing.Optional[typing.List[str]] = pydantic.Field(
        default=None,
        description="A list of alternate names that the location is known as, or was known as, in the past.",
    )
    description: typing.Optional[str] = pydantic.Field(
        default=None, description="Description of the Location, which helps in finding or referencing the place."
    )
    mode: typing.Optional[LocationMode] = pydantic.Field(
        default=None,
        description="Indicates whether a resource instance represents a specific location or a class of locations.",
    )
    type: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None, description="Indicates the type of function performed at the location."
    )
    telecom: typing.Optional[typing.List[ContactPoint]] = pydantic.Field(
        default=None,
        description="The contact details of communication devices available at the location. This can include phone numbers, fax numbers, mobile numbers, email addresses and web sites.",
    )
    address: typing.Optional[Address] = pydantic.Field(default=None, description="Physical location.")
    physical_type: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="physicalType",
        default=None,
        description="Physical form of the location, e.g. building, room, vehicle, road.",
    )
    position: typing.Optional[LocationPosition] = pydantic.Field(
        default=None,
        description="The absolute geographic location of the Location, expressed using the WGS84 datum (This is the same co-ordinate system used in KML).",
    )
    managing_organization: typing.Optional[Reference] = pydantic.Field(
        alias="managingOrganization",
        default=None,
        description="The organization responsible for the provisioning and upkeep of the location.",
    )
    part_of: typing.Optional[Reference] = pydantic.Field(
        alias="partOf", default=None, description="Another Location of which this Location is physically a part of."
    )
    hours_of_operation: typing.Optional[typing.List[LocationHoursOfOperation]] = pydantic.Field(
        alias="hoursOfOperation",
        default=None,
        description="What days/times during a week is this location usually open.",
    )
    availability_exceptions: typing.Optional[str] = pydantic.Field(
        alias="availabilityExceptions",
        default=None,
        description="A description of when the locations opening ours are different to normal, e.g. public holiday availability. Succinctly describing all possible exceptions to normal site availability as detailed in the opening hours Times.",
    )
    endpoint: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None, description="Technical endpoints providing access to services operated for the location."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
