# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class LocationStatus(str, enum.Enum):
    """
    The status property covers the general availability of the resource, not the current value which may be covered by the operationStatus, or by a schedule/slots if they are configured for the location.
    """

    ACTIVE = "active"
    SUSPENDED = "suspended"
    INACTIVE = "inactive"

    def visit(
        self,
        active: typing.Callable[[], T_Result],
        suspended: typing.Callable[[], T_Result],
        inactive: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is LocationStatus.ACTIVE:
            return active()
        if self is LocationStatus.SUSPENDED:
            return suspended()
        if self is LocationStatus.INACTIVE:
            return inactive()
