# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .code import Code
from .id import Id
from .instant import Instant
from .login_auth_method import LoginAuthMethod
from .login_code_challenge_method import LoginCodeChallengeMethod
from .meta import Meta
from .reference import Reference
from .uri import Uri

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Login(pydantic.BaseModel):
    """
    Login event and session details.
    """

    resource_type: typing.Literal["Login"] = pydantic.Field(alias="resourceType")
    id: typing.Optional[Id] = pydantic.Field(
        default=None,
        description="The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.",
    )
    meta: typing.Optional[Meta] = pydantic.Field(
        default=None,
        description="The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.",
    )
    implicit_rules: typing.Optional[Uri] = pydantic.Field(
        alias="implicitRules",
        default=None,
        description="A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.",
    )
    language: typing.Optional[Code] = pydantic.Field(
        default=None, description="The base language in which the resource is written."
    )
    client: typing.Optional[Reference] = pydantic.Field(default=None, description="The client requesting the code.")
    profile_type: typing.Optional[Code] = pydantic.Field(
        alias="profileType", default=None, description="Optional required profile resource type."
    )
    project: typing.Optional[Reference] = pydantic.Field(
        default=None, description="Optional required project for the login."
    )
    user: Reference = pydantic.Field(description="The user requesting the code.")
    membership: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="Reference to the project membership which includes FHIR identity (patient, practitioner, etc), access policy, and user configuration.",
    )
    scope: typing.Optional[str] = pydantic.Field(default=None, description="OAuth scope or scopes.")
    auth_method: LoginAuthMethod = pydantic.Field(
        alias="authMethod", description="The authentication method used to obtain the code (password or google)."
    )
    auth_time: Instant = pydantic.Field(alias="authTime", description="Time when the End-User authentication occurred.")
    cookie: typing.Optional[str] = pydantic.Field(
        default=None, description="The cookie value that can be used for session management."
    )
    code: typing.Optional[str] = pydantic.Field(
        default=None,
        description="The authorization code generated by the authorization server. The authorization code MUST expire shortly after it is issued to mitigate the risk of leaks. A maximum authorization code lifetime of 10 minutes is RECOMMENDED. The client MUST NOT use the authorization code more than once. If an authorization code is used more than once, the authorization server MUST deny the request and SHOULD revoke (when possible) all tokens previously issued based on that authorization code. The authorization code is bound to the client identifier and redirection URI.",
    )
    code_challenge: typing.Optional[str] = pydantic.Field(
        alias="codeChallenge", default=None, description="PKCE code challenge presented in the authorization request."
    )
    code_challenge_method: typing.Optional[LoginCodeChallengeMethod] = pydantic.Field(
        alias="codeChallengeMethod",
        default=None,
        description='OPTIONAL, defaults to "plain" if not present in the request. Code verifier transformation method is "S256" or "plain".',
    )
    refresh_secret: typing.Optional[str] = pydantic.Field(
        alias="refreshSecret",
        default=None,
        description="Optional secure random string that can be used in an OAuth refresh token.",
    )
    nonce: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Optional cryptographically random string that your app adds to the initial request and the authorization server includes inside the ID Token, used to prevent token replay attacks.",
    )
    mfa_verified: typing.Optional[bool] = pydantic.Field(
        alias="mfaVerified",
        default=None,
        description="Whether the user has verified using multi-factor authentication (MFA). This will only be set is the user has MFA enabled (see User.mfaEnrolled).",
    )
    granted: typing.Optional[bool] = pydantic.Field(
        default=None, description="Whether a token has been granted for this login."
    )
    revoked: typing.Optional[bool] = pydantic.Field(
        default=None, description="Whether this login has been revoked or invalidated."
    )
    admin: typing.Optional[bool] = pydantic.Field(default=None, description="DEPRECATED")
    super_admin: typing.Optional[bool] = pydantic.Field(
        alias="superAdmin", default=None, description="Whether this login has super administrator privileges."
    )
    launch: typing.Optional[Reference] = pydantic.Field(
        default=None, description="Optional SMART App Launch context for this login."
    )
    remote_address: typing.Optional[str] = pydantic.Field(
        alias="remoteAddress",
        default=None,
        description="The Internet Protocol (IP) address of the client or last proxy that sent the request.",
    )
    user_agent: typing.Optional[str] = pydantic.Field(
        alias="userAgent", default=None, description="The User-Agent request header as sent by the client."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
