# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class LoginAuthMethod(str, enum.Enum):
    """
    The authentication method used to obtain the code (password or google).
    """

    CLIENT = "client"
    EXCHANGE = "exchange"
    EXECUTE = "execute"
    EXTERNAL = "external"
    GOOGLE = "google"
    PASSWORD = "password"

    def visit(
        self,
        client: typing.Callable[[], T_Result],
        exchange: typing.Callable[[], T_Result],
        execute: typing.Callable[[], T_Result],
        external: typing.Callable[[], T_Result],
        google: typing.Callable[[], T_Result],
        password: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is LoginAuthMethod.CLIENT:
            return client()
        if self is LoginAuthMethod.EXCHANGE:
            return exchange()
        if self is LoginAuthMethod.EXECUTE:
            return execute()
        if self is LoginAuthMethod.EXTERNAL:
            return external()
        if self is LoginAuthMethod.GOOGLE:
            return google()
        if self is LoginAuthMethod.PASSWORD:
            return password()
