# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .canonical import Canonical
from .codeable_concept import CodeableConcept
from .contact_detail import ContactDetail
from .date_time import DateTime
from .identifier import Identifier
from .markdown import Markdown
from .measure_group import MeasureGroup
from .measure_status import MeasureStatus
from .measure_supplemental_data import MeasureSupplementalData
from .period import Period
from .reference import Reference
from .related_artifact import RelatedArtifact
from .uri import Uri
from .usage_context import UsageContext

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Measure(BaseResource):
    """
    The Measure resource provides the definition of a quality measure.
    """

    resource_type: typing.Literal["Measure"] = pydantic.Field(alias="resourceType")
    url: typing.Optional[Uri] = pydantic.Field(
        default=None,
        description="An absolute URI that is used to identify this measure when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this measure is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the measure is stored on different servers.",
    )
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None,
        description="A formal identifier that is used to identify this measure when it is represented in other formats, or referenced in a specification, model, design or an instance.",
    )
    version: typing.Optional[str] = pydantic.Field(
        default=None,
        description="The identifier that is used to identify this version of the measure when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the measure author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active artifacts.",
    )
    name: typing.Optional[str] = pydantic.Field(
        default=None,
        description="A natural language name identifying the measure. This name should be usable as an identifier for the module by machine processing applications such as code generation.",
    )
    title: typing.Optional[str] = pydantic.Field(
        default=None, description="A short, descriptive, user-friendly title for the measure."
    )
    subtitle: typing.Optional[str] = pydantic.Field(
        default=None,
        description="An explanatory or alternate title for the measure giving additional information about its content.",
    )
    status: typing.Optional[MeasureStatus] = pydantic.Field(
        default=None, description="The status of this measure. Enables tracking the life-cycle of the content."
    )
    experimental: typing.Optional[bool] = pydantic.Field(
        default=None,
        description="A Boolean value to indicate that this measure is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.",
    )
    subject_codeable_concept: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="subjectCodeableConcept",
        default=None,
        description="The intended subjects for the measure. If this element is not provided, a Patient subject is assumed, but the subject of the measure can be anything.",
    )
    subject_reference: typing.Optional[Reference] = pydantic.Field(
        alias="subjectReference",
        default=None,
        description="The intended subjects for the measure. If this element is not provided, a Patient subject is assumed, but the subject of the measure can be anything.",
    )
    date: typing.Optional[DateTime] = pydantic.Field(
        default=None,
        description="The date (and optionally time) when the measure was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the measure changes.",
    )
    publisher: typing.Optional[str] = pydantic.Field(
        default=None, description="The name of the organization or individual that published the measure."
    )
    contact: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(
        default=None, description="Contact details to assist a user in finding and communicating with the publisher."
    )
    description: typing.Optional[Markdown] = pydantic.Field(
        default=None,
        description="A free text natural language description of the measure from a consumer's perspective.",
    )
    use_context: typing.Optional[typing.List[UsageContext]] = pydantic.Field(
        alias="useContext",
        default=None,
        description="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate measure instances.",
    )
    jurisdiction: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None, description="A legal or geographic region in which the measure is intended to be used."
    )
    purpose: typing.Optional[Markdown] = pydantic.Field(
        default=None, description="Explanation of why this measure is needed and why it has been designed as it has."
    )
    usage: typing.Optional[str] = pydantic.Field(
        default=None, description="A detailed description, from a clinical perspective, of how the measure is used."
    )
    copyright: typing.Optional[Markdown] = pydantic.Field(
        default=None,
        description="A copyright statement relating to the measure and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the measure.",
    )
    approval_date: typing.Optional[dt.date] = pydantic.Field(
        alias="approvalDate",
        default=None,
        description="The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.",
    )
    last_review_date: typing.Optional[dt.date] = pydantic.Field(
        alias="lastReviewDate",
        default=None,
        description="The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.",
    )
    effective_period: typing.Optional[Period] = pydantic.Field(
        alias="effectivePeriod",
        default=None,
        description="The period during which the measure content was or is planned to be in active use.",
    )
    topic: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None,
        description="Descriptive topics related to the content of the measure. Topics provide a high-level categorization grouping types of measures that can be useful for filtering and searching.",
    )
    author: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(
        default=None,
        description="An individiual or organization primarily involved in the creation and maintenance of the content.",
    )
    editor: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(
        default=None,
        description="An individual or organization primarily responsible for internal coherence of the content.",
    )
    reviewer: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(
        default=None,
        description="An individual or organization primarily responsible for review of some aspect of the content.",
    )
    endorser: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(
        default=None,
        description="An individual or organization responsible for officially endorsing the content for use in some setting.",
    )
    related_artifact: typing.Optional[typing.List[RelatedArtifact]] = pydantic.Field(
        alias="relatedArtifact",
        default=None,
        description="Related artifacts such as additional documentation, justification, or bibliographic references.",
    )
    library: typing.Optional[typing.List[Canonical]] = pydantic.Field(
        default=None, description="A reference to a Library resource containing the formal logic used by the measure."
    )
    disclaimer: typing.Optional[Markdown] = pydantic.Field(
        default=None,
        description="Notices and disclaimers regarding the use of the measure or related to intellectual property (such as code systems) referenced by the measure.",
    )
    scoring: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None,
        description="Indicates how the calculation is performed for the measure, including proportion, ratio, continuous-variable, and cohort. The value set is extensible, allowing additional measure scoring types to be represented.",
    )
    composite_scoring: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="compositeScoring",
        default=None,
        description="If this is a composite measure, the scoring method used to combine the component measures to determine the composite score.",
    )
    type: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None,
        description="Indicates whether the measure is used to examine a process, an outcome over time, a patient-reported outcome, or a structure measure such as utilization.",
    )
    risk_adjustment: typing.Optional[str] = pydantic.Field(
        alias="riskAdjustment",
        default=None,
        description="A description of the risk adjustment factors that may impact the resulting score for the measure and how they may be accounted for when computing and reporting measure results.",
    )
    rate_aggregation: typing.Optional[str] = pydantic.Field(
        alias="rateAggregation",
        default=None,
        description="Describes how to combine the information calculated, based on logic in each of several populations, into one summarized result.",
    )
    rationale: typing.Optional[Markdown] = pydantic.Field(
        default=None,
        description="Provides a succinct statement of the need for the measure. Usually includes statements pertaining to importance criterion: impact, gap in care, and evidence.",
    )
    clinical_recommendation_statement: typing.Optional[Markdown] = pydantic.Field(
        alias="clinicalRecommendationStatement",
        default=None,
        description="Provides a summary of relevant clinical guidelines or other clinical recommendations supporting the measure.",
    )
    improvement_notation: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="improvementNotation",
        default=None,
        description="Information on whether an increase or decrease in score is the preferred result (e.g., a higher score indicates better quality OR a lower score indicates better quality OR quality is within a range).",
    )
    definition: typing.Optional[typing.List[Markdown]] = pydantic.Field(
        default=None, description="Provides a description of an individual term used within the measure."
    )
    guidance: typing.Optional[Markdown] = pydantic.Field(
        default=None,
        description="Additional guidance for the measure including how it can be used in a clinical context, and the intent of the measure.",
    )
    group: typing.Optional[typing.List[MeasureGroup]] = pydantic.Field(
        default=None, description="A group of population criteria for the measure."
    )
    supplemental_data: typing.Optional[typing.List[MeasureSupplementalData]] = pydantic.Field(
        alias="supplementalData",
        default=None,
        description="The supplemental data criteria for the measure report, specified as either the name of a valid CQL expression within a referenced library, or a valid FHIR Resource Path.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
