# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class MeasureReportType(str, enum.Enum):
    """
    The type of measure report. This may be an individual report, which provides the score for the measure for an individual member of the population; a subject-listing, which returns the list of members that meet the various criteria in the measure; a summary report, which returns a population count for each of the criteria in the measure; or a data-collection, which enables the MeasureReport to be used to exchange the data-of-interest for a quality measure.
    """

    INDIVIDUAL = "individual"
    SUBJECT_LIST = "subject-list"
    SUMMARY = "summary"
    DATA_COLLECTION = "data-collection"

    def visit(
        self,
        individual: typing.Callable[[], T_Result],
        subject_list: typing.Callable[[], T_Result],
        summary: typing.Callable[[], T_Result],
        data_collection: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is MeasureReportType.INDIVIDUAL:
            return individual()
        if self is MeasureReportType.SUBJECT_LIST:
            return subject_list()
        if self is MeasureReportType.SUMMARY:
            return summary()
        if self is MeasureReportType.DATA_COLLECTION:
            return data_collection()
