# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .annotation import Annotation
from .base_resource import BaseResource
from .code import Code
from .codeable_concept import CodeableConcept
from .date_time import DateTime
from .dosage import Dosage
from .identifier import Identifier
from .medication_dispense_performer import MedicationDispensePerformer
from .medication_dispense_substitution import MedicationDispenseSubstitution
from .quantity import Quantity
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class MedicationDispense(BaseResource):
    """
    Indicates that a medication product is to be or has been dispensed for a named person/patient. This includes a description of the medication product (supply) provided and the instructions for administering the medication. The medication dispense is the result of a pharmacy system responding to a medication order.
    """

    resource_type: typing.Literal["MedicationDispense"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None,
        description="Identifiers associated with this Medication Dispense that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.",
    )
    part_of: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="partOf", default=None, description="The procedure that trigger the dispense."
    )
    status: typing.Optional[Code] = pydantic.Field(
        default=None, description="A code specifying the state of the set of dispense events."
    )
    status_reason_codeable_concept: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="statusReasonCodeableConcept",
        default=None,
        description="Indicates the reason why a dispense was not performed.",
    )
    status_reason_reference: typing.Optional[Reference] = pydantic.Field(
        alias="statusReasonReference",
        default=None,
        description="Indicates the reason why a dispense was not performed.",
    )
    category: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None,
        description="Indicates the type of medication dispense (for example, where the medication is expected to be consumed or administered (i.e. inpatient or outpatient)).",
    )
    medication_codeable_concept: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="medicationCodeableConcept",
        default=None,
        description="Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.",
    )
    medication_reference: typing.Optional[Reference] = pydantic.Field(
        alias="medicationReference",
        default=None,
        description="Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.",
    )
    subject: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="A link to a resource representing the person or the group to whom the medication will be given.",
    )
    context: typing.Optional[Reference] = pydantic.Field(
        default=None, description="The encounter or episode of care that establishes the context for this event."
    )
    supporting_information: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="supportingInformation",
        default=None,
        description="Additional information that supports the medication being dispensed.",
    )
    performer: typing.Optional[typing.List[MedicationDispensePerformer]] = pydantic.Field(
        default=None, description="Indicates who or what performed the event."
    )
    location: typing.Optional[Reference] = pydantic.Field(
        default=None, description="The principal physical location where the dispense was performed."
    )
    authorizing_prescription: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="authorizingPrescription",
        default=None,
        description="Indicates the medication order that is being dispensed against.",
    )
    type: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None,
        description="Indicates the type of dispensing event that is performed. For example, Trial Fill, Completion of Trial, Partial Fill, Emergency Fill, Samples, etc.",
    )
    quantity: typing.Optional[Quantity] = pydantic.Field(
        default=None, description="The amount of medication that has been dispensed. Includes unit of measure."
    )
    days_supply: typing.Optional[Quantity] = pydantic.Field(
        alias="daysSupply", default=None, description="The amount of medication expressed as a timing amount."
    )
    when_prepared: typing.Optional[DateTime] = pydantic.Field(
        alias="whenPrepared", default=None, description="The time when the dispensed product was packaged and reviewed."
    )
    when_handed_over: typing.Optional[DateTime] = pydantic.Field(
        alias="whenHandedOver",
        default=None,
        description="The time the dispensed product was provided to the patient or their representative.",
    )
    destination: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="Identification of the facility/location where the medication was shipped to, as part of the dispense event.",
    )
    receiver: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None,
        description="Identifies the person who picked up the medication. This will usually be a patient or their caregiver, but some cases exist where it can be a healthcare professional.",
    )
    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(
        default=None,
        description="Extra information about the dispense that could not be conveyed in the other attributes.",
    )
    dosage_instruction: typing.Optional[typing.List[Dosage]] = pydantic.Field(
        alias="dosageInstruction",
        default=None,
        description="Indicates how the medication is to be used by the patient.",
    )
    substitution: typing.Optional[MedicationDispenseSubstitution] = pydantic.Field(
        default=None,
        description="Indicates whether or not substitution was made as part of the dispense. In some cases, substitution will be expected but does not happen, in other cases substitution is not expected but does happen. This block explains what substitution did or did not happen and why. If nothing is specified, substitution was not done.",
    )
    detected_issue: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="detectedIssue",
        default=None,
        description="Indicates an actual or potential clinical issue with or between one or more active or proposed clinical actions for a patient; e.g. drug-drug interaction, duplicate therapy, dosage alert etc.",
    )
    event_history: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="eventHistory",
        default=None,
        description="A summary of the events of interest that have occurred, such as when the dispense was verified.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
