# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .annotation import Annotation
from .base_resource import BaseResource
from .code import Code
from .codeable_concept import CodeableConcept
from .date_time import DateTime
from .dosage import Dosage
from .identifier import Identifier
from .period import Period
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class MedicationStatement(BaseResource):
    """
    A record of a medication that is being consumed by a patient. A MedicationStatement may indicate that the patient may be taking the medication now or has taken the medication in the past or will be taking the medication in the future. The source of this information can be the patient, significant other (such as a family member or spouse), or a clinician. A common scenario where this information is captured is during the history taking process during a patient visit or stay. The medication information may come from sources such as the patient's memory, from a prescription bottle, or from a list of medications the patient, clinician or other party maintains. The primary difference between a medication statement and a medication administration is that the medication administration has complete administration information and is based on actual administration information from the person who administered the medication. A medication statement is often, if not always, less specific. There is no required date/time when the medication was administered, in fact we only know that a source has reported the patient is taking this medication, where details such as time, quantity, or rate or even medication product may be incomplete or missing or less precise. As stated earlier, the medication statement information may come from the patient's memory, from a prescription bottle or from a list of medications the patient, clinician or other party maintains. Medication administration is more formal and is not missing detailed information.
    """

    resource_type: typing.Literal["MedicationStatement"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None,
        description="Identifiers associated with this Medication Statement that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.",
    )
    based_on: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="basedOn",
        default=None,
        description="A plan, proposal or order that is fulfilled in whole or in part by this event.",
    )
    part_of: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="partOf",
        default=None,
        description="A larger event of which this particular event is a component or step.",
    )
    status: typing.Optional[Code] = pydantic.Field(
        default=None,
        description="A code representing the patient or other source's judgment about the state of the medication used that this statement is about. Generally, this will be active or completed.",
    )
    status_reason: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        alias="statusReason",
        default=None,
        description="Captures the reason for the current state of the MedicationStatement.",
    )
    category: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None, description="Indicates where the medication is expected to be consumed or administered."
    )
    medication_codeable_concept: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="medicationCodeableConcept",
        default=None,
        description="Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.",
    )
    medication_reference: typing.Optional[Reference] = pydantic.Field(
        alias="medicationReference",
        default=None,
        description="Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.",
    )
    subject: Reference = pydantic.Field(description="The person, animal or group who is/was taking the medication.")
    context: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="The encounter or episode of care that establishes the context for this MedicationStatement.",
    )
    effective_date_time: typing.Optional[str] = pydantic.Field(
        alias="effectiveDateTime",
        default=None,
        description="The interval of time during which it is being asserted that the patient is/was/will be taking the medication (or was not taking, when the MedicationStatement.taken element is No).",
    )
    effective_period: typing.Optional[Period] = pydantic.Field(
        alias="effectivePeriod",
        default=None,
        description="The interval of time during which it is being asserted that the patient is/was/will be taking the medication (or was not taking, when the MedicationStatement.taken element is No).",
    )
    date_asserted: typing.Optional[DateTime] = pydantic.Field(
        alias="dateAsserted",
        default=None,
        description="The date when the medication statement was asserted by the information source.",
    )
    information_source: typing.Optional[Reference] = pydantic.Field(
        alias="informationSource",
        default=None,
        description="The person or organization that provided the information about the taking of this medication. Note: Use derivedFrom when a MedicationStatement is derived from other resources, e.g. Claim or MedicationRequest.",
    )
    derived_from: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="derivedFrom",
        default=None,
        description="Allows linking the MedicationStatement to the underlying MedicationRequest, or to other information that supports or is used to derive the MedicationStatement.",
    )
    reason_code: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        alias="reasonCode", default=None, description="A reason for why the medication is being/was taken."
    )
    reason_reference: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="reasonReference",
        default=None,
        description="Condition or observation that supports why the medication is being/was taken.",
    )
    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(
        default=None,
        description="Provides extra information about the medication statement that is not conveyed by the other attributes.",
    )
    dosage: typing.Optional[typing.List[Dosage]] = pydantic.Field(
        default=None, description="Indicates how the medication is/was or should be taken by the patient."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
