# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .coding import Coding
from .identifier import Identifier
from .marketing_status import MarketingStatus
from .medicinal_product_manufacturing_business_operation import MedicinalProductManufacturingBusinessOperation
from .medicinal_product_name import MedicinalProductName
from .medicinal_product_special_designation import MedicinalProductSpecialDesignation
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class MedicinalProduct(BaseResource):
    """
    Detailed definition of a medicinal product, typically for uses other than direct patient care (e.g. regulatory use).
    """

    resource_type: typing.Literal["MedicinalProduct"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None, description="Business identifier for this product. Could be an MPID."
    )
    type: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None, description="Regulatory type, e.g. Investigational or Authorized."
    )
    domain: typing.Optional[Coding] = pydantic.Field(
        default=None, description="If this medicine applies to human or veterinary uses."
    )
    combined_pharmaceutical_dose_form: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="combinedPharmaceuticalDoseForm",
        default=None,
        description="The dose form for a single part product, or combined form of a multiple part product.",
    )
    legal_status_of_supply: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="legalStatusOfSupply",
        default=None,
        description="The legal status of supply of the medicinal product as classified by the regulator.",
    )
    additional_monitoring_indicator: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="additionalMonitoringIndicator",
        default=None,
        description="Whether the Medicinal Product is subject to additional monitoring for regulatory reasons.",
    )
    special_measures: typing.Optional[typing.List[str]] = pydantic.Field(
        alias="specialMeasures",
        default=None,
        description="Whether the Medicinal Product is subject to special measures for regulatory reasons.",
    )
    paediatric_use_indicator: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="paediatricUseIndicator", default=None, description="If authorised for use in children."
    )
    product_classification: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        alias="productClassification",
        default=None,
        description="Allows the product to be classified by various systems.",
    )
    marketing_status: typing.Optional[typing.List[MarketingStatus]] = pydantic.Field(
        alias="marketingStatus",
        default=None,
        description="Marketing status of the medicinal product, in contrast to marketing authorizaton.",
    )
    pharmaceutical_product: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="pharmaceuticalProduct", default=None, description="Pharmaceutical aspects of product."
    )
    packaged_medicinal_product: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="packagedMedicinalProduct", default=None, description="Package representation for the product."
    )
    attached_document: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="attachedDocument",
        default=None,
        description="Supporting documentation, typically for regulatory submission.",
    )
    master_file: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="masterFile",
        default=None,
        description="A master file for to the medicinal product (e.g. Pharmacovigilance System Master File).",
    )
    contact: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None, description="A product specific contact, person (in a role), or an organization."
    )
    clinical_trial: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="clinicalTrial", default=None, description="Clinical trials or studies that this product is involved in."
    )
    name: typing.List[MedicinalProductName] = pydantic.Field(
        description="The product's name, including full name and possibly coded parts."
    )
    cross_reference: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        alias="crossReference",
        default=None,
        description="Reference to another product, e.g. for linking authorised to investigational product.",
    )
    manufacturing_business_operation: typing.Optional[
        typing.List[MedicinalProductManufacturingBusinessOperation]
    ] = pydantic.Field(
        alias="manufacturingBusinessOperation",
        default=None,
        description="An operation applied to the product, for manufacturing or adminsitrative purpose.",
    )
    special_designation: typing.Optional[typing.List[MedicinalProductSpecialDesignation]] = pydantic.Field(
        alias="specialDesignation",
        default=None,
        description="Indicates if the medicinal product has an orphan designation for the treatment of a rare disease.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
