# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .medicinal_product_contraindication_other_therapy import MedicinalProductContraindicationOtherTherapy
from .population import Population
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class MedicinalProductContraindication(BaseResource):
    """
    The clinical particulars - indications, contraindications etc. of a medicinal product, including for regulatory purposes.
    """

    resource_type: typing.Literal["MedicinalProductContraindication"] = pydantic.Field(alias="resourceType")
    subject: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None, description="The medication for which this is an indication."
    )
    disease: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None, description="The disease, symptom or procedure for the contraindication."
    )
    disease_status: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="diseaseStatus",
        default=None,
        description="The status of the disease or symptom for the contraindication.",
    )
    comorbidity: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None, description="A comorbidity (concurrent condition) or coinfection."
    )
    therapeutic_indication: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="therapeuticIndication",
        default=None,
        description="Information about the use of the medicinal product in relation to other therapies as part of the indication.",
    )
    other_therapy: typing.Optional[typing.List[MedicinalProductContraindicationOtherTherapy]] = pydantic.Field(
        alias="otherTherapy",
        default=None,
        description="Information about the use of the medicinal product in relation to other therapies described as part of the indication.",
    )
    population: typing.Optional[typing.List[Population]] = pydantic.Field(
        default=None, description="The population group to which this applies."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
