# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .medicinal_product_indication_other_therapy import MedicinalProductIndicationOtherTherapy
from .population import Population
from .quantity import Quantity
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class MedicinalProductIndication(BaseResource):
    """
    Indication for the Medicinal Product.
    """

    resource_type: typing.Literal["MedicinalProductIndication"] = pydantic.Field(alias="resourceType")
    subject: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None, description="The medication for which this is an indication."
    )
    disease_symptom_procedure: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="diseaseSymptomProcedure",
        default=None,
        description="The disease, symptom or procedure that is the indication for treatment.",
    )
    disease_status: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="diseaseStatus",
        default=None,
        description="The status of the disease or symptom for which the indication applies.",
    )
    comorbidity: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None, description="Comorbidity (concurrent condition) or co-infection as part of the indication."
    )
    intended_effect: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="intendedEffect",
        default=None,
        description="The intended effect, aim or strategy to be achieved by the indication.",
    )
    duration: typing.Optional[Quantity] = pydantic.Field(
        default=None, description="Timing or duration information as part of the indication."
    )
    other_therapy: typing.Optional[typing.List[MedicinalProductIndicationOtherTherapy]] = pydantic.Field(
        alias="otherTherapy",
        default=None,
        description="Information about the use of the medicinal product in relation to other therapies described as part of the indication.",
    )
    undesirable_effect: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="undesirableEffect",
        default=None,
        description="Describe the undesirable effects of the medicinal product.",
    )
    population: typing.Optional[typing.List[Population]] = pydantic.Field(
        default=None, description="The population group to which this applies."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
