# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .identifier import Identifier
from .medicinal_product_ingredient_specified_substance import MedicinalProductIngredientSpecifiedSubstance
from .medicinal_product_ingredient_substance import MedicinalProductIngredientSubstance
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class MedicinalProductIngredient(BaseResource):
    """
    An ingredient of a manufactured item or pharmaceutical product.
    """

    resource_type: typing.Literal["MedicinalProductIngredient"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[Identifier] = pydantic.Field(
        default=None,
        description="The identifier(s) of this Ingredient that are assigned by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate.",
    )
    role: CodeableConcept = pydantic.Field(description="Ingredient role e.g. Active ingredient, excipient.")
    allergenic_indicator: typing.Optional[bool] = pydantic.Field(
        alias="allergenicIndicator", default=None, description="If the ingredient is a known or suspected allergen."
    )
    manufacturer: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None, description="Manufacturer of this Ingredient."
    )
    specified_substance: typing.Optional[typing.List[MedicinalProductIngredientSpecifiedSubstance]] = pydantic.Field(
        alias="specifiedSubstance", default=None, description="A specified substance that comprises this ingredient."
    )
    substance: typing.Optional[MedicinalProductIngredientSubstance] = pydantic.Field(
        default=None, description="The ingredient substance."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
