# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .codeable_concept import CodeableConcept
from .date_time import DateTime
from .extension import Extension
from .identifier import Identifier
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class MedicinalProductManufacturingBusinessOperation(pydantic.BaseModel):
    """
    Detailed definition of a medicinal product, typically for uses other than direct patient care (e.g. regulatory use).
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    modifier_extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        alias="modifierExtension",
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
    )
    operation_type: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="operationType", default=None, description="The type of manufacturing operation."
    )
    authorisation_reference_number: typing.Optional[Identifier] = pydantic.Field(
        alias="authorisationReferenceNumber", default=None, description="Regulatory authorization reference number."
    )
    effective_date: typing.Optional[DateTime] = pydantic.Field(
        alias="effectiveDate", default=None, description="Regulatory authorization date."
    )
    confidentiality_indicator: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="confidentialityIndicator",
        default=None,
        description="To indicate if this proces is commercially confidential.",
    )
    manufacturer: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None, description="The manufacturer or establishment associated with the process."
    )
    regulator: typing.Optional[Reference] = pydantic.Field(
        default=None, description="A regulator which oversees the operation."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
