# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .identifier import Identifier
from .medicinal_product_pharmaceutical_characteristics import MedicinalProductPharmaceuticalCharacteristics
from .medicinal_product_pharmaceutical_route_of_administration import (
    MedicinalProductPharmaceuticalRouteOfAdministration,
)
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class MedicinalProductPharmaceutical(BaseResource):
    """
    A pharmaceutical product described in terms of its composition and dose form.
    """

    resource_type: typing.Literal["MedicinalProductPharmaceutical"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None, description="An identifier for the pharmaceutical medicinal product."
    )
    administrable_dose_form: CodeableConcept = pydantic.Field(
        alias="administrableDoseForm", description="The administrable dose form, after necessary reconstitution."
    )
    unit_of_presentation: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="unitOfPresentation", default=None, description="Todo."
    )
    ingredient: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None, description="Ingredient.")
    device: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None, description="Accompanying device.")
    characteristics: typing.Optional[typing.List[MedicinalProductPharmaceuticalCharacteristics]] = pydantic.Field(
        default=None, description="Characteristics e.g. a products onset of action."
    )
    route_of_administration: typing.List[MedicinalProductPharmaceuticalRouteOfAdministration] = pydantic.Field(
        alias="routeOfAdministration",
        description="The path by which the pharmaceutical product is taken into or makes contact with the body.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
