# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class MessageDefinitionResponseRequired(str, enum.Enum):
    """
    Declare at a message definition level whether a response is required or only upon error or success, or never.
    """

    ALWAYS = "always"
    ON_ERROR = "on-error"
    NEVER = "never"
    ON_SUCCESS = "on-success"

    def visit(
        self,
        always: typing.Callable[[], T_Result],
        on_error: typing.Callable[[], T_Result],
        never: typing.Callable[[], T_Result],
        on_success: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is MessageDefinitionResponseRequired.ALWAYS:
            return always()
        if self is MessageDefinitionResponseRequired.ON_ERROR:
            return on_error()
        if self is MessageDefinitionResponseRequired.NEVER:
            return never()
        if self is MessageDefinitionResponseRequired.ON_SUCCESS:
            return on_success()
