# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .base_resource import BaseResource
from .canonical import Canonical
from .codeable_concept import CodeableConcept
from .coding import Coding
from .message_header_destination import MessageHeaderDestination
from .message_header_response import MessageHeaderResponse
from .message_header_source import MessageHeaderSource
from .reference import Reference

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class MessageHeader(BaseResource):
    """
    The header for a message exchange that is either requesting or responding to an action. The reference(s) that are the subject of the action as well as other information related to the action are typically transmitted in a bundle in which the MessageHeader resource instance is the first resource in the bundle.
    """

    resource_type: typing.Literal["MessageHeader"] = pydantic.Field(alias="resourceType")
    event_coding: typing.Optional[Coding] = pydantic.Field(
        alias="eventCoding",
        default=None,
        description='Code that identifies the event this message represents and connects it with its definition. Events defined as part of the FHIR specification have the system value "http://terminology.hl7.org/CodeSystem/message-events". Alternatively uri to the EventDefinition.',
    )
    event_uri: typing.Optional[str] = pydantic.Field(
        alias="eventUri",
        default=None,
        description='Code that identifies the event this message represents and connects it with its definition. Events defined as part of the FHIR specification have the system value "http://terminology.hl7.org/CodeSystem/message-events". Alternatively uri to the EventDefinition.',
    )
    destination: typing.Optional[typing.List[MessageHeaderDestination]] = pydantic.Field(
        default=None, description="The destination application which the message is intended for."
    )
    sender: typing.Optional[Reference] = pydantic.Field(
        default=None, description="Identifies the sending system to allow the use of a trust relationship."
    )
    enterer: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="The person or device that performed the data entry leading to this message. When there is more than one candidate, pick the most proximal to the message. Can provide other enterers in extensions.",
    )
    author: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="The logical author of the message - the person or device that decided the described event should happen. When there is more than one candidate, pick the most proximal to the MessageHeader. Can provide other authors in extensions.",
    )
    source: MessageHeaderSource = pydantic.Field(
        description="The source application from which this message originated."
    )
    responsible: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="The person or organization that accepts overall responsibility for the contents of the message. The implication is that the message event happened under the policies of the responsible party.",
    )
    reason: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None,
        description="Coded indication of the cause for the event - indicates a reason for the occurrence of the event that is a focus of this message.",
    )
    response: typing.Optional[MessageHeaderResponse] = pydantic.Field(
        default=None,
        description="Information about the message that this message is a response to. Only present if this message is a response.",
    )
    focus: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None, description="The actual data of the message - a reference to the root/focus class of the event."
    )
    definition: typing.Optional[Canonical] = pydantic.Field(
        default=None, description="Permanent link to the MessageDefinition for this message."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
