# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class MessageHeaderResponseCode(str, enum.Enum):
    """
    Code that identifies the type of response to the message - whether it was successful or not, and whether it should be resent or not.
    """

    OK = "ok"
    TRANSIENT_ERROR = "transient-error"
    FATAL_ERROR = "fatal-error"

    def visit(
        self,
        ok: typing.Callable[[], T_Result],
        transient_error: typing.Callable[[], T_Result],
        fatal_error: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is MessageHeaderResponseCode.OK:
            return ok()
        if self is MessageHeaderResponseCode.TRANSIENT_ERROR:
            return transient_error()
        if self is MessageHeaderResponseCode.FATAL_ERROR:
            return fatal_error()
