# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class MolecularSequenceReferenceSeqOrientation(str, enum.Enum):
    """
    A relative reference to a DNA strand based on gene orientation. The strand that contains the open reading frame of the gene is the "sense" strand, and the opposite complementary strand is the "antisense" strand.
    """

    SENSE = "sense"
    ANTISENSE = "antisense"

    def visit(self, sense: typing.Callable[[], T_Result], antisense: typing.Callable[[], T_Result]) -> T_Result:
        if self is MolecularSequenceReferenceSeqOrientation.SENSE:
            return sense()
        if self is MolecularSequenceReferenceSeqOrientation.ANTISENSE:
            return antisense()
