# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .extension import Extension
from .molecular_sequence_repository_type import MolecularSequenceRepositoryType
from .uri import Uri

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class MolecularSequenceRepository(pydantic.BaseModel):
    """
    Raw data describing a biological sequence.
    """

    id: typing.Optional[str] = pydantic.Field(
        default=None,
        description="Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.",
    )
    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.",
    )
    modifier_extension: typing.Optional[typing.List[Extension]] = pydantic.Field(
        alias="modifierExtension",
        default=None,
        description="May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
    )
    type: typing.Optional[MolecularSequenceRepositoryType] = pydantic.Field(
        default=None,
        description="Click and see / RESTful API / Need login to see / RESTful API with authentication / Other ways to see resource.",
    )
    url: typing.Optional[Uri] = pydantic.Field(
        default=None,
        description="URI of an external repository which contains further details about the genetics data.",
    )
    name: typing.Optional[str] = pydantic.Field(
        default=None,
        description="URI of an external repository which contains further details about the genetics data.",
    )
    dataset_id: typing.Optional[str] = pydantic.Field(
        alias="datasetId",
        default=None,
        description="Id of the variant in this external repository. The server will understand how to use this id to call for more info about datasets in external repository.",
    )
    variantset_id: typing.Optional[str] = pydantic.Field(
        alias="variantsetId",
        default=None,
        description="Id of the variantset in this external repository. The server will understand how to use this id to call for more info about variantsets in external repository.",
    )
    readset_id: typing.Optional[str] = pydantic.Field(
        alias="readsetId", default=None, description="Id of the read in this external repository."
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
