# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class NarrativeStatus(str, enum.Enum):
    """
    The status of the narrative - whether it's entirely generated (from just the defined data or the extensions too), or whether a human authored it and it may contain additional data.
    """

    GENERATED = "generated"
    EXTENSIONS = "extensions"
    ADDITIONAL = "additional"
    EMPTY = "empty"

    def visit(
        self,
        generated: typing.Callable[[], T_Result],
        extensions: typing.Callable[[], T_Result],
        additional: typing.Callable[[], T_Result],
        empty: typing.Callable[[], T_Result],
    ) -> T_Result:
        if self is NarrativeStatus.GENERATED:
            return generated()
        if self is NarrativeStatus.EXTENSIONS:
            return extensions()
        if self is NarrativeStatus.ADDITIONAL:
            return additional()
        if self is NarrativeStatus.EMPTY:
            return empty()
