# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ...core.datetime_utils import serialize_datetime
from .annotation import Annotation
from .base_resource import BaseResource
from .codeable_concept import CodeableConcept
from .identifier import Identifier
from .instant import Instant
from .observation_component import ObservationComponent
from .observation_reference_range import ObservationReferenceRange
from .observation_status import ObservationStatus
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .sampled_data import SampledData
from .timing import Timing

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Observation(BaseResource):
    """
    Measurements and simple assertions made about a patient, device or other subject.
    """

    resource_type: typing.Literal["Observation"] = pydantic.Field(alias="resourceType")
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(
        default=None, description="A unique identifier assigned to this observation."
    )
    based_on: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="basedOn",
        default=None,
        description="A plan, proposal or order that is fulfilled in whole or in part by this event. For example, a MedicationRequest may require a patient to have laboratory test performed before it is dispensed.",
    )
    part_of: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="partOf",
        default=None,
        description="A larger event of which this particular Observation is a component or step. For example, an observation as part of a procedure.",
    )
    status: typing.Optional[ObservationStatus] = pydantic.Field(
        default=None, description="The status of the result value."
    )
    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None, description="A code that classifies the general type of observation being made."
    )
    code: CodeableConcept = pydantic.Field(
        description='Describes what was observed. Sometimes this is called the observation "name".'
    )
    subject: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="The patient, or group of patients, location, or device this observation is about and into whose record the observation is placed. If the actual focus of the observation is different from the subject (or a sample of, part, or region of the subject), the `focus` element or the `code` itself specifies the actual focus of the observation.",
    )
    focus: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None,
        description="The actual focus of an observation when it is not the patient of record representing something or someone associated with the patient such as a spouse, parent, fetus, or donor. For example, fetus observations in a mother's record. The focus of an observation could also be an existing condition, an intervention, the subject's diet, another observation of the subject, or a body structure such as tumor or implanted device. An example use case would be using the Observation resource to capture whether the mother is trained to change her child's tracheostomy tube. In this example, the child is the patient of record and the mother is the focus.",
    )
    encounter: typing.Optional[Reference] = pydantic.Field(
        default=None,
        description="The healthcare event (e.g. a patient and healthcare provider interaction) during which this observation is made.",
    )
    effective_date_time: typing.Optional[str] = pydantic.Field(
        alias="effectiveDateTime",
        default=None,
        description='The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the "physiologically relevant time". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.',
    )
    effective_period: typing.Optional[Period] = pydantic.Field(
        alias="effectivePeriod",
        default=None,
        description='The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the "physiologically relevant time". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.',
    )
    effective_timing: typing.Optional[Timing] = pydantic.Field(
        alias="effectiveTiming",
        default=None,
        description='The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the "physiologically relevant time". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.',
    )
    effective_instant: typing.Optional[str] = pydantic.Field(
        alias="effectiveInstant",
        default=None,
        description='The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the "physiologically relevant time". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.',
    )
    issued: typing.Optional[Instant] = pydantic.Field(
        default=None,
        description="The date and time this version of the observation was made available to providers, typically after the results have been reviewed and verified.",
    )
    performer: typing.Optional[typing.List[Reference]] = pydantic.Field(
        default=None, description='Who was responsible for asserting the observed value as "true".'
    )
    value_quantity: typing.Optional[Quantity] = pydantic.Field(
        alias="valueQuantity",
        default=None,
        description="The information determined as a result of making the observation, if the information has a simple value.",
    )
    value_codeable_concept: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="valueCodeableConcept",
        default=None,
        description="The information determined as a result of making the observation, if the information has a simple value.",
    )
    value_string: typing.Optional[str] = pydantic.Field(
        alias="valueString",
        default=None,
        description="The information determined as a result of making the observation, if the information has a simple value.",
    )
    value_boolean: typing.Optional[bool] = pydantic.Field(
        alias="valueBoolean",
        default=None,
        description="The information determined as a result of making the observation, if the information has a simple value.",
    )
    value_integer: typing.Optional[float] = pydantic.Field(
        alias="valueInteger",
        default=None,
        description="The information determined as a result of making the observation, if the information has a simple value.",
    )
    value_range: typing.Optional[Range] = pydantic.Field(
        alias="valueRange",
        default=None,
        description="The information determined as a result of making the observation, if the information has a simple value.",
    )
    value_ratio: typing.Optional[Ratio] = pydantic.Field(
        alias="valueRatio",
        default=None,
        description="The information determined as a result of making the observation, if the information has a simple value.",
    )
    value_sampled_data: typing.Optional[SampledData] = pydantic.Field(
        alias="valueSampledData",
        default=None,
        description="The information determined as a result of making the observation, if the information has a simple value.",
    )
    value_time: typing.Optional[str] = pydantic.Field(
        alias="valueTime",
        default=None,
        description="The information determined as a result of making the observation, if the information has a simple value.",
    )
    value_date_time: typing.Optional[str] = pydantic.Field(
        alias="valueDateTime",
        default=None,
        description="The information determined as a result of making the observation, if the information has a simple value.",
    )
    value_period: typing.Optional[Period] = pydantic.Field(
        alias="valuePeriod",
        default=None,
        description="The information determined as a result of making the observation, if the information has a simple value.",
    )
    data_absent_reason: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="dataAbsentReason",
        default=None,
        description="Provides a reason why the expected value in the element Observation.value[x] is missing.",
    )
    interpretation: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None, description="A categorical assessment of an observation value. For example, high, low, normal."
    )
    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(
        default=None, description="Comments about the observation or the results."
    )
    body_site: typing.Optional[CodeableConcept] = pydantic.Field(
        alias="bodySite",
        default=None,
        description="Indicates the site on the subject's body where the observation was made (i.e. the target site).",
    )
    method: typing.Optional[CodeableConcept] = pydantic.Field(
        default=None, description="Indicates the mechanism used to perform the observation."
    )
    specimen: typing.Optional[Reference] = pydantic.Field(
        default=None, description="The specimen that was used when this observation was made."
    )
    device: typing.Optional[Reference] = pydantic.Field(
        default=None, description="The device used to generate the observation data."
    )
    reference_range: typing.Optional[typing.List[ObservationReferenceRange]] = pydantic.Field(
        alias="referenceRange",
        default=None,
        description='Guidance on how to interpret the value by comparison to a normal or recommended range. Multiple reference ranges are interpreted as an "OR". In other words, to represent two distinct target populations, two `referenceRange` elements would be used.',
    )
    has_member: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="hasMember",
        default=None,
        description="This observation is a group observation (e.g. a battery, a panel of tests, a set of vital sign measurements) that includes the target as a member of the group.",
    )
    derived_from: typing.Optional[typing.List[Reference]] = pydantic.Field(
        alias="derivedFrom",
        default=None,
        description="The target resource that represents a measurement from which this observation value is derived. For example, a calculated anion gap or a fetal measurement based on an ultrasound image.",
    )
    component: typing.Optional[typing.List[ObservationComponent]] = pydantic.Field(
        default=None,
        description="Some observations have multiple component observations. These component observations are expressed as separate code value pairs that share the same attributes. Examples include systolic and diastolic component observations for blood pressure measurement and multiple component observations for genetics observations.",
    )

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
